<?php

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/downloads/core/class_template.php');
}


class vB_ProfileBlock_DBTech_Downloads extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_downloads_memberinfo_block_downloads';

	var $nowrap = true;

	var $skip_privacy_check = true;

	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
			'perpage'    => 25,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $vbphrase, $prepared;
		
		if (!class_exists('Downloads'))
		{
			require_once(DIR . '/dbtech/downloads/core/class_download.php');
			
			$dbtech_class = 'Downloads';
			
			if (file_exists(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php')) {
			    require_once(DIR . '/dbtech/downloads_pro/core/class_downloads_pro.php');
			    
			    $dbtech_class = 'Downloads_Pro';
			}
			
			Downloads::init($this->registry);
			
		}
		
		require_once(DIR . '/includes/class_bbcode.php');
		
		$bbcode = new vB_BbCodeParser($this->registry, fetch_tag_list());
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}

		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];

		// Count number of users
		$count = $this->registry->db->query_first("
			SELECT COUNT(groupid) AS total FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
			WHERE userid = " . intval($this->profile->userinfo['userid']) . "
		");

		// Ensure every result is as it should be
		sanitize_pageresults($count['total'], $pagenumber, $perpage);

		// Find out where to start
		$start  = ($pagenumber - 1) * $perpage;
		$end    = $start + $perpage;

		// Constructs the page navigation
		$pagenav = construct_page_nav(
			$pagenumber,
			$perpage,
			$count['total'],
			'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'],
			"&amp;tab=$id&amp;perpage=$perpage"
		);

		// Page navigation registration
		$this->block_data['pagenav'] = $pagenav;

		// Fetch users
		$downloads = $this->registry->db->query_read("
			SELECT filegroup.*, u.username FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup AS filegroup
			LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
			WHERE u.userid = " . intval($prepared['userid']) . "
			ORDER BY filegroup.updated DESC
			LIMIT $start, $end
		");

		$downloadsbits = '';
		while ($download = $this->registry->db->fetch_array($downloads)) {
			$dtemplate = vB_Template::create('dbtech_downloads_memberinfo_block_downloads_bits');

			$download['updated']    = vbdate('M jS Y \a\t h:i a', $download['updated'], true, false);
			$download['rating']     = Downloads::beautify_rating($download['rating']);

			if (strlen($download['groupdesc']) > 200) {
				$download['groupdesc'] = substr($download['groupdesc'], 0, 200) . '...';
			}
			
			$download['groupdesc'] = $bbcode->parse(strip_tags(Downloads::convert_wysiwyg_html_to_bbcode($download['groupdesc'])), 'nonforum');
			
			$dtemplate->register('download', $download);

			$downloadsbits .= $dtemplate->render();
		}

		$this->block_data['downloadsbits'] = $downloadsbits;
		$this->block_data['x_downloads']   = construct_phrase($vbphrase['dbtech_downloads_x_downloads'], $prepared['musername']);
		
		return $this->block_data;
	}
}
?>